using System;
using System.Linq;
using System.Linq.Expressions;
using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Repository.Data;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Repository.Extensions;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.Repository.Repositories.Interface;

namespace Siger.Middlelayer.Repository.Repositories
{
    internal class SigerCompanyRepository : ApiConfigRepositoryBase<siger_company>, ISigerCompanyRepository
    {
        private readonly ApiConfigDbContext _context;
        public SigerCompanyRepository(ApiConfigDbContext context) : base(context)
        {
            _context = context;
        }

        public IPagedCollectionResult<Company> GetPagedCollectionResult(string chinesename, string province, string city, string county,
            string industry_first, string industry_second, int page, int pagesize)
        {
            var query = _context.siger_company.Where(q => q.status == (int)RowState.Valid);
            var querylist = from q in query
                join in1 in _context.siger_industry_first on q.industry_first equals in1.id into com1
                from temp in com1.DefaultIfEmpty()
                join in2 in _context.siger_industry_second on q.industry_second equals in2.id into com2
                from temp2 in com2.DefaultIfEmpty()
                select new Company
                {
                    id = q.id,
                    chinesename = q.chinesename,
                    chinesepinyin = q.chinesepinyin,
                    companycode = q.companycode,
                    contact = q.contact,
                    description = q.description,
                    detailaddress = q.detailaddress,
                    email = q.email,
                    identification = q.identification,
                    industry = temp != null ? (temp2 != null ? temp.name + "-" + temp2.name : temp.name) : "",
                    litpic = q.litpic,
                    telephone = q.telephone,
                    website = q.website,
                    province = q.province,
                    city = q.city,
                    county = q.county,
                    industry_first = q.industry_first,
                    industry_second = q.industry_second,
                    create_time = q.create_time
                };

            Expression<Func<Company, bool>> namExpression = q => true;
            if (!string.IsNullOrEmpty(chinesename))
            {
                namExpression = q => q.chinesename.Contains(chinesename);
            }
            Expression<Func<Company, bool>> provinceExpression = q => true;
            if (!string.IsNullOrEmpty(province))
            {
                provinceExpression = q => q.province == province;
            }
            Expression<Func<Company, bool>> cityExpression = q => true;
            if (!string.IsNullOrEmpty(city))
            {
                cityExpression = q => q.city == city;
            }
            Expression<Func<Company, bool>> countyExpression = q => true;
            if (!string.IsNullOrEmpty(county))
            {
                countyExpression = q => q.county == county;
            }
            Expression<Func<Company, bool>> industryfirstExpression = q => true;
            if (!string.IsNullOrEmpty(industry_first))
            {
                industryfirstExpression = q => q.industry_first == int.Parse(industry_first);
            }
            Expression<Func<Company, bool>> industrysecondExpression = q => true;
            if (!string.IsNullOrEmpty(industry_second))
            {
                industrysecondExpression = q => q.industry_second == int.Parse(industry_second);
            }

            var predicate = namExpression.And(provinceExpression)
                .And(cityExpression).And(countyExpression).And(industryfirstExpression)
                .And(industrysecondExpression);

            var totalCount = querylist.Count(predicate);
            var entities = querylist.Where(predicate).OrderBy(q => q.id).Skip((page - 1) * pagesize).Take(pagesize).AsNoTracking().ToList();

            return new PagedCollectionResult<Company>(entities, totalCount);
        }
    }
}
