﻿using System.ComponentModel.DataAnnotations;

namespace Siger.Middlelayer.Repository.Request
{
    public class RequestAddUserPower
    {
        [Required(ErrorMessage = "NameIsEmpty")]
        public string name { get; set; }

        [Required(ErrorMessage = "DescriptionIsEmpty")]
        public string description { get; set; }

        [Required(ErrorMessage = "UserPowerIsEmpty")]
        public string value { get; set; }

        [Required(ErrorMessage = "ParnetPowerIsEmpty")]
        public string parent { get; set; }

        public string icon { get; set; }

        public string sorting { get; set; }

        public string type { get; set; }

        public string url { get; set; } = string.Empty;
    }

    public class RequestUpdateUserPower : RequestAddUserPower
    {
        [Required(ErrorMessage = "IdIsEmpty")]
        public int id { get; set; }
    }
}
