﻿using System.Collections.Generic;
using Siger.Middlelayer.Repository;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Repository.Response;
using Siger.Middlelayer.TlmRepository.Entities;
using Siger.Middlelayer.TlmRepository.Request;
using Siger.Middlelayer.TlmRepository.Response;
using Siger.Middlelayer.WmsRepository.Entities;

namespace Siger.Middlelayer.TlmRepository.Repositories.Interface
{
    public interface ITlmRepositoryBase<TEntity> : IRepositoryBase<TEntity> where TEntity : TlmEntityBase
    {
        IEnumerable<ResponseGetMaterials> GetMaterials(RequestGetMaterial request);
        IEnumerable<ResponseGetMaterials> GetMaterials(string category, string name, string cutter_number, string product_id, string route, int projectid);

        IEnumerable<ResponseIdName> GetSuppliersByPartNo(int material_id, string partNo, int projectid);

        IEnumerable<ResponseRoutes> GetRouteList(int productId, int projectid);

        siger_project_product_route GetProductRoute(int id, int projectid);

        IEnumerable<ResponseGetMaterials> GetMaterialList(int id, string part_no,int count, int projectid);

        siger_tr_materials GetMaterial(int id, string part_no, int projectid);

        siger_project_user GetProjectUser(int id, int projectid);

        siger_wms_stock GetStockTrace(string serial_number, int state, int projectid);

        IEnumerable<ResponseGetMaterialList> GetToolMaterialList(int id, string part_no, string name,int projectid);

        siger_wms_bussinese_contacts GetSupplier(int id, int projectid);

        IEnumerable<ResponseGetToolStockMaterials> GetStokcs(int material_id, int supplier_id, string serial_number, int projectid);

        IEnumerable<GetStockStorage> GetStockStorage(int material_id);

        siger_project_product GetProduct(int productId, int projectid);

        siger_wms_stock GetSerialNoStock(string serial_number, int state, int projectid);

        List<siger_project_machine> GetMachineInfo(int section, int projectId);
    }
}
