﻿using Siger.Middlelayer.Common.FieldEnum;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;

namespace Siger.Middlelayer.TlmRepository.Request
{
    public class RequestAddCategory
    {
        [Required(ErrorMessage = "NameIsEmpty")]
        public string name { get; set; }

        [Required(ErrorMessage = "CodeIsEmpty")]
        public string code { get; set; }

        public int type { get; set; }

        public string parent { get; set; }
    }

    public class RequestUpdateCategory: RequestAddCategory
    {
        public int id { get; set; }
    }

    public class RequestUpdateCategoryParameter
    {
        public int id { get; set; }

        public string category { get; set; }

        public IEnumerable<int> parameters { get; set; }
    }
}
