using System.ComponentModel.DataAnnotations;

namespace Siger.Middlelayer.ToolRepository.Entities
{
    /// <summary>
    /// siger_project_tool_cutter_location_true Entity Model
    /// </summary>   
    public class SigerProjectToolCutterLocationTrue : ToolEntityBase
    {
        /// <summary>
        /// 
        /// </summary>
        [Key]
        public int id { get; set; }
   
        /// <summary>
        /// 刀位名称
        /// </summary>
        public string name { get; set; }
   
        /// <summary>
        /// 主轴id
        /// </summary>
        public int spindleid { get; set; }
   
        /// <summary>
        /// 
        /// </summary>
        public int status { get; set; }
   
        /// <summary>
        /// 刀具id
        /// </summary>
        public int? toolid { get; set; }
   
        /// <summary>
        /// 转速S（转/分）
        /// </summary>
        public int? speed { get; set; }
   
        /// <summary>
        /// 进给量（毫米/转）
        /// </summary>
        public float? feedrate { get; set; }
   
        /// <summary>
        /// 吃刀量/钻深（毫米）
        /// </summary>
        public string cuttingdepth { get; set; }
   
        /// <summary>
        /// 加工尺寸
        /// </summary>
        public string machiningtolerance { get; set; }
   
        /// <summary>
        /// 直径补偿
        /// </summary>
        public float? dcompensate { get; set; }
   
        /// <summary>
        /// 半径补偿
        /// </summary>
        public float? rcompensate { get; set; }
   
        /// <summary>
        /// x轴
        /// </summary>
        public float? x { get; set; }
   
        /// <summary>
        /// y轴
        /// </summary>
        public float? y { get; set; }
   
        /// <summary>
        /// z轴
        /// </summary>
        public float? z { get; set; }
   
        /// <summary>
        /// 冷却方式
        /// </summary>
        public string cooling { get; set; }
   
        /// <summary>
        /// 备注
        /// </summary>
        public string description { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public int? ratedlife { get; set; } = 0;

        /// <summary>
        /// 产品id
        /// </summary>
        public int? productid { get; set; } = 0;
   
        /// <summary>
        /// 
        /// </summary>
        public string image_url { get; set; }
   
        /// <summary>
        /// 程序号
        /// </summary>
        public string programno { get; set; }

        /// <summary>
        /// 子程序号
        /// </summary>
        public string subprogramno { get; set; }

        /// <summary>
        /// 0： 未配置程序号 1-:加工程序号为主程序 2-加工程序号为子程序；
        /// </summary>
        public int is_processing_program { get; set; } = 0;
   
        /// <summary>
        /// 程序类型  0：无类型  1：主程序  2：子程序
        /// </summary>
        public int? program_type { get; set; }

        /// <summary>
        /// 控制线自动学习 1开启 0关闭
        /// </summary>
        public int? auto_study { get; set; } = 1;
   
        /// <summary>
        /// 是否与数采数据一致
        /// </summary>
        public int? is_identical_collection { get; set; }

        /// <summary>
        /// 刀位别名
        /// </summary>
        public string cutter_location_alias { get; set; }
   
        /// <summary>
        /// 创建时间
        /// </summary>
        public int? create_time { get; set; }
   
        /// <summary>
        /// 更新时间
        /// </summary>
        public int? update_time { get; set; }

        //是否设置磨损学习,0:否 1: 是
        public int msStudied { get; set; }

        public int type { get; set; }
        /// <summary>
        /// 寿命系数
        /// </summary>
        public double coefficent { get; set; }
    }
}
