
using System;

namespace Siger.Middlelayer.TpmRepository.Entities
{
    /// <summary>
    /// siger_project_sparepart Entity Model
    /// </summary>   
    public class siger_project_sparepart : TpmEntityBase
    {
        /// <summary>
        /// 编号
        /// </summary>
        public string code { get; set; }
   
        /// <summary>
        /// 项目 id
        /// </summary>
        public int projectid { get; set; }
   
        /// <summary>
        /// 名称
        /// </summary>
        public string title { get; set; } = string.Empty;

        /// <summary>
        /// 描述
        /// </summary>
        public string description { get; set; } = string.Empty;

        /// <summary>
        /// 创建时间
        /// </summary>
        public int time { get; set; } = 0;
   
        /// <summary>
        /// 创建ip
        /// </summary>
        public string create_ip { get; set; } = string.Empty;

        /// <summary>
        /// 创建者mid
        /// </summary>
        public int create_mid { get; set; } = 0;

        /// <summary>
        /// _project_sparepart_type.id 备件类型id
        /// </summary>
        public int typeid { get; set; } = 0;
   
        /// <summary>
        /// 图片url
        /// </summary>
        public string image { get; set; } = string.Empty;

        /// <summary>
        /// 规格型号
        /// </summary>
        public string param { get; set; } = string.Empty;

        /// <summary>
        /// 品牌
        /// </summary>
        public string brand { get; set; } = string.Empty;

        /// <summary>
        /// 是否需要置换 1->是 0->否
        /// </summary>
        public int is_substitute { get; set; } = 0;
   
        /// <summary>
        /// 计量单位
        /// </summary>
        public string unit { get; set; } = string.Empty;

        /// <summary>
        /// 单价
        /// </summary>
        public double price { get; set; } = 0;
   
        /// <summary>
        /// 材质
        /// </summary>
        public string material { get; set; } = string.Empty;

        /// <summary>
        /// 是否为标准件 1->是 0->否
        /// </summary>
        public int is_standard { get; set; } = 0;

        /// <summary>
        /// 是否通用配件 1->是 0->否
        /// </summary>
        public int is_common { get; set; } = 1;
   
        /// <summary>
        /// 最高库存
        /// </summary>
        public int max_sku { get; set; }
   
        /// <summary>
        /// 最低库存
        /// </summary>
        public int mini_sku { get; set; }

        /// <summary>
        /// 当前库存
        /// </summary>
        public int sku { get; set; } = 0;
   
        /// <summary>
        /// 所在仓库位置
        /// </summary>
        public string warehouse { get; set; } = string.Empty;

        /// <summary>
        /// 库存报警提示人的mid
        /// </summary>
        public string sku_report_mid { get; set; } = string.Empty;

        /// <summary>
        /// 备注
        /// </summary>
        public string remark { get; set; } = string.Empty;
   
        /// <summary>
        /// 供应商
        /// </summary>
        public string supplier { get; set; } = string.Empty;

        /// <summary>
        /// 0=>无状态 1=>采购中
        /// </summary>
        public int purchase_status { get; set; } = 0;

        /// <summary>
        /// 货期
        /// </summary>
        public float delivery_time { get; set; } = 0;

        /// <summary>
        /// 维修上限
        /// </summary>
        public double? repair_upperlimit { get; set; }

        public int approvaluser_mid { get; set; } = 0;
        /// <summary>
        /// 最小起订量
        /// </summary>
        public int sku_limit { get; set; } = 0;
        /// <summary>
        /// 订购时间
        /// </summary>
        public long order_time { get; set; } = 0;
    }
}
