﻿using System.Collections.Generic;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.Repository.Response;
using Siger.Middlelayer.TpmRepository.Entities;
using Siger.Middlelayer.TpmRepository.Request;
using Siger.Middlelayer.TpmRepository.Response;
using Siger.Middlelayer.Utility.ImportEntities;

namespace Siger.Middlelayer.TpmRepository.Repositories.Interface
{
    public interface ISparepartRepository : ITpmRepositoryBase<siger_project_sparepart>
    {
        IPagedCollectionResult<ResponseGetSparepart> GetPagedList(int machinetype1, int machinetype2, string keyword,
            string s_is_standard, string s_is_substitute, string s_report, int lastCheckValsparepart, IEnumerable<int> lastCheckVal, 
            int charger, int projectId,int page, int pagesize, string key="", string order="", bool paged = true);

        CommonImportResult ImportSparepart(IEnumerable<SparepartListForImport> types, int projectId, int userId);

        IEnumerable<RepsonseGetSparepartList> GetSparepartListByMachineId(int machineId, int projectid);
        IPagedCollectionResult<ResponseSparepartInfo> GetSparepartListInfo(RequestSparepartInfo condition, int pid);

        IEnumerable<RepsonseGetSparepartList> GetReplaceSparepartsByMachineId(IEnumerable<int> machineIds, int projectid);

        IEnumerable<RsponseAlarmSparepart> GetAlarmSpareparts(int projectId);
        bool InsertList(List<siger_project_sparepart> list);
    }
}
