﻿
using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Repository.Extensions;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.TpmRepository.Entities;
using Siger.Middlelayer.TpmRepository.Repositories.Interface;
using Siger.Middlelayer.TpmRepository.Response;
using System;
using System.Linq;
using System.Linq.Expressions;

namespace Siger.Middlelayer.TpmRepository.Repositories
{
    /// <summary>
	/// SigerProjectSparepartOrderDetail
	/// </summary>
    internal class SigerProjectSparepartOrderDetail : TpmRepositoryBase<siger_project_sparepart_order_detail>, ISigerProjectSparepartOrderDetail
    {
        private readonly ApiTpmDbContext _context;

        public SigerProjectSparepartOrderDetail(ApiTpmDbContext context) : base(context)
        {
            _context = context;
        }
        public IPagedCollectionResult<ResponseSparepartOrderDetail> GetDetailInfo(string ordercode, int pid, int page, int pagesize)
        {
            var query = _context.siger_project_sparepart_order_detail.Where(f => f.projectid.Equals(pid) && f.status == (int)RowState.Valid && f.order_code.Equals(ordercode));
            var querylist = from q in query
                            join sp in _context.siger_project_sparepart on q.sparepart_code equals sp.code into d
                            from sp in d.DefaultIfEmpty()
                            where sp.status == (int)RowState.Valid && sp.projectid == pid
                            select new ResponseSparepartOrderDetail
                            {
                                code = q.sparepart_code,
                                title = sp.title,
                                sku = sp.sku,
                                mini_sku = sp.mini_sku,
                                max_sku=sp.max_sku,
                                sku_limit = sp.sku_limit,
                                count = q.count,
                                id=q.id,
                            };
            var count = querylist.Count();
            var entities = querylist.Skip((page - 1) * pagesize).Take(pagesize).AsNoTracking().ToList();
            return new PagedCollectionResult<ResponseSparepartOrderDetail>(entities, count);
        }
    }
}
