﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.Middlelayer.Dapper.CheckTrace.Data
{
    public class SnTrace
    {
        public long ID { get; set; }

        public int ProductID { get; set; }

        public int MaterialID { get; set; }

        public int SectionID { get; set; }

        public int MachineID { get; set; }

        public string WorkOrder { get; set; }

        public string SN { get; set; }

        public string Result { get; set; }

        public int UserID { get; set; }

        public int RouteID { get; set; }

        public DateTime CreateTime { get; set; }

        public int CheckType { get; set; }

        public string ItemName { get; set; } = string.Empty;
    }

    public class SnTraceDetail
    {
        public long ID { get; set; }

        public long TraceID { get; set; }

        public int ItemID { get; set; }

        public string ItemName { get; set; } = string.Empty;

        public string Result { get; set; }

        public double? Value { get; set; }

        public string SN { get; set; }
    }

    public class SnTraceDetailList : SnTraceDetail
    {
        public int NumberIndex { get; set; }

        public double? LowerLimit { get; set; }

        public double? UpperLimit { get; set; }
    }
}
