﻿using System;
using System.Collections.Generic;
using System.Text;
using Dapper;
using Siger.Middlelayer.Dapper.CheckTrace.Data;
using Siger.Middlelayer.Dapper.CheckTrace.Constant;
using System.Linq;
using System.Threading.Tasks;
using Siger.Middlelayer.Common.Extensions;
using Siger.Middlelayer.Common.Log;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.ModuleEnum;

namespace Siger.Middlelayer.Dapper.CheckTrace.Repostriories
{
    public class TraceDataRepository : TraceDbContext
    {
        public TraceDataRepository(int companyId, int projectId) : base(companyId, projectId)
        {
        }

        public List<SubTable> GetSubTableList(string name)
        {
            using (var conn = GetDbConnection())
            {
                var sql = $"select * from {TabelNameConstant.SubTableTable} where tablename='{name}' and status=1";
                var dataList = conn.Query<SubTable>(sql);
                return dataList.ToList();
            }
        }

        public IEnumerable<SnTrace> GetSnTraceList(int projectid)
        {
                var sql = $@"select ID,ProductID,MaterialID,SectionID,WorkOrder,SN,Result,UserID,CreateTime,RouteID,CheckType
    from {TabelNameConstant.SnTraceTable}
    where Status={(int)RowState.Valid} and ProjectID={projectid} and UserID>0
    order by CreateTime";
                var dataList = GetDataList<SnTrace>(sql);
                return dataList;
        }

        public IEnumerable<SnTraceDetail> GetSingleTraceDetailList(long traceId, int projectid)
        {
            var snTraces = new List<SnTraceDetail>();
            var subTables = GetSubTableList(TabelNameConstant.SnTraceDetailTable);
            if (subTables.Count > 0)
            {
                Parallel.ForEach(subTables, new ParallelOptions { MaxDegreeOfParallelism = subTables.Count },
                    t => { snTraces.AddRange(GetSingleTraceDetails(t, traceId, projectid)); });
            }
            Task.WaitAll();
            return snTraces.ToList();
        }

        private IEnumerable<SnTraceDetail> GetSingleTraceDetails(SubTable table, long traceId, int projectid)
        {
            var conditon = string.Empty;
            if (traceId > 0)
            {
                conditon += $" and TraceID={traceId}";
            }

            var sql = $@"select ID,ItemID,TraceID,Result,Value,ItemName,SN
                from {table.name}
                where Status=1 and ProjectID={projectid} {conditon}";
            var dataList = GetDataList<SnTraceDetail>(sql);
            return dataList;
        }

        public SnTrace GetSnTrace(long id, int projectid)
        {
            using (var conn = GetDbConnection())
            {
                var sql = $"select * from {TabelNameConstant.SnTraceTable} where ID={id} and Status=1 and ProjectID={projectid}";
                var data = conn.QuerySingleOrDefault<SnTrace>(sql);
                return data;
            }
        }

        public void UpdateSnTraceWorkOrder(long id, string workorder, int projectid)
        {
            using (var conn = GetDbConnection())
            {
                var sql = $"update {TabelNameConstant.SnTraceTable} set WorkOrder='{workorder}' where ID={id} and Status=1 and ProjectID={projectid}";
                var data = conn.Execute(sql);
            }
        }

        public override void Dispose()
        {
            throw new NotImplementedException();
        }
    }
}
