﻿using System;
using System.Collections.Generic;
using System.Text;
using Dapper;
using Siger.Middlelayer.Dapper.CheckTrace.Data;
using Siger.Middlelayer.Dapper.CheckTrace.Constant;
using System.Linq;
using System.Threading.Tasks;
using Siger.Middlelayer.Common.Extensions;
using Siger.Middlelayer.Common.Log;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.ModuleEnum;

namespace Siger.Middlelayer.Dapper.CheckTrace.Repostriories
{
    public class TraceDetailRepository : TraceDbContext
    {
        public TraceDetailRepository(int companyId, int projectId) : base(companyId, projectId)
        {
        }

        public List<SubTable> GetSubTableList(string name)
        {
            using (var conn = GetDbConnection())
            {
                var sql = $"select * from {TabelNameConstant.SubTableTable} where tablename='{name}' and status=1";
                var dataList = conn.Query<SubTable>(sql);
                return dataList.ToList();
            }
        }

        /// <summary>
        /// 查询分页 和 导出获取数据
        /// </summary>
        /// <param name="sectionId"></param>
        /// <param name="productId"></param>
        /// <param name="materialId"></param>
        /// <param name="routeId"></param>
        /// <param name="checkType"></param>
        /// <param name="sn"></param>
        /// <param name="result"></param>
        /// <param name="ids">siger_check_sn_trace.ID</param>
        /// <param name="starttime"></param>
        /// <param name="endtime"></param>
        /// <param name="page"></param>
        /// <param name="pagesize"></param>
        /// <param name="projectid"></param>
        /// <param name="toexcel"></param>
        /// <param name="userId"></param>
        /// <param name="userCheck">0->查询所有数据 1->查询有检验人的数据</param>
        /// <param name="okContainsDeviation">查询OK的时候是否包含偏差放行 true->包含 false->不包含</param>
        /// <param name="inspectionType">1->送检数据 2->人工检验数据</param>
        /// <returns></returns>
        public IEnumerable<SnTrace> GetSnTracePageList(List<int> sectionId, int productId, int materialId, int routeId, int checkType, string sn, string result, List<long> ids, 
            string starttime, string endtime, int page, int pagesize, int projectid, string toexcel, int userId, int userCheck = 0, bool okContainsDeviation = true, int inspectionType = 0)
        {
            var conditon = GetCondition(sectionId, productId, materialId, routeId, checkType, sn, result, ids,
                starttime, endtime, userId, userCheck);

            var pageLimit = "";
            if(toexcel.ToInt() == 0)
            {
                pageLimit = $" limit { (page - 1) * pagesize},{ pagesize}";
            }
            if (!string.IsNullOrEmpty(result) && (result.ToUpper() == "OK" || result == ((int)SendTestType.DeviationRelease).ToString()) &&
                    okContainsDeviation == false)
            {
                var dbName = GetDbName();
                var midDbName = GetMidDataBaseName();
                var sql = $@"select t.ID,t.ProductID,t.MaterialID,t.SectionID,t.WorkOrder,t.SN,t.Result,t.UserID,t.CreateTime,t.RouteID,t.CheckType
    from {dbName}.{TabelNameConstant.SnTraceTable} t left join {midDbName}.{TabelNameConstant.TraceInspection} s on t.ID=s.trace_id
    where t.Status=1 and t.ProjectID={projectid} and (s.result='{((int)SendTestType.Qalified).ToString()}' or s.result is null) and 
    (s.status=1 or s.status is null) and (s.projectid={projectid} or s.projectid is null) {conditon}
    order by t.CreateTime DESC {pageLimit}";
                var dataList = GetDataList<SnTrace>(sql);
                return dataList;
            }
            else if (inspectionType == (int)InspectionType.ManualCollection)
            {
                var dbName = GetDbName();
                var midDbName = GetMidDataBaseName();
                var sql = $@"select t.ID,t.ProductID,t.MaterialID,t.SectionID,t.WorkOrder,t.SN,t.Result,t.UserID,t.CreateTime,t.RouteID,t.CheckType
    from {dbName}.{TabelNameConstant.SnTraceTable} t left join {midDbName}.{TabelNameConstant.TraceInspection} s on t.ID=s.trace_id
    where t.Status=1 and t.ProjectID={projectid} and (s.inspection_type={(int)InspectionType.ManualCollection} or s.trace_id is NULL) and 
    (s.status=1 or s.status is null) and (s.projectid={projectid} or s.projectid is null) {conditon}
    order by t.CreateTime DESC {pageLimit}";
                var dataList = GetDataList<SnTrace>(sql);
                return dataList;
            }
            else
            {
                var sql = $@"select t.ID,t.ProductID,t.MaterialID,t.SectionID,t.WorkOrder,t.SN,t.Result,t.UserID,t.CreateTime,t.RouteID,t.CheckType
    from {TabelNameConstant.SnTraceTable} t 
    where t.Status=1 and t.ProjectID={projectid} {conditon}
    order by t.CreateTime DESC {pageLimit}";
                var dataList = GetDataList<SnTrace>(sql);
                return dataList;
            }
        }

        public long CountTrace(List<int> sectionId, int productId, int materialId, int routeId, int checkType, string sn, string result, List<long> ids,
            string starttime, string endtime, int projectid, int userId, int userCheck = 0, bool okContainsDeviation = true, int inspectionType = 0)
        {
            using (var conn = GetDbConnection())
            {
                var conditon = GetCondition(sectionId, productId, materialId, routeId, checkType, sn, result, ids,
                    starttime, endtime, userId, userCheck);
                if(!string.IsNullOrEmpty(result) && (result.ToUpper() == "OK" || result == ((int)SendTestType.DeviationRelease).ToString()) &&
                        okContainsDeviation == false)
                {
                    var dbName = GetDbName();
                    var midDbName = GetMidDataBaseName();
                    var res = conn.ExecuteScalar<long>($@"select count(1) from {dbName}.{TabelNameConstant.SnTraceTable} t left join {midDbName}.{TabelNameConstant.TraceInspection} s on t.ID=s.trace_id
                     where t.Status=1 and t.ProjectID={projectid} and (s.result='{((int)SendTestType.Qalified).ToString()}' or s.result is null) and 
                     (s.status=1 or s.status is null) and (s.projectid={projectid} or s.projectid is null) {conditon}");
                    return res;
                }
                else if(inspectionType == (int)InspectionType.ManualCollection)
                {
                    var dbName = GetDbName();
                    var midDbName = GetMidDataBaseName();
                    var sql = $@"select count(1) from {dbName}.{TabelNameConstant.SnTraceTable} t left join {midDbName}.{TabelNameConstant.TraceInspection} s on t.ID=s.trace_id
                     where t.Status=1 and t.ProjectID={projectid} and (s.inspection_type={(int)InspectionType.ManualCollection} ||  s.trace_id is NULL) and
                    (s.status=1 or s.status is null) and (s.projectid={projectid} or s.projectid is null) {conditon}";
                    var res = conn.ExecuteScalar<long>(sql);
                    return res;
                }
                else
                {
                    var res = conn.ExecuteScalar<long>($@"select count(1) from {TabelNameConstant.SnTraceTable} t 
                     where t.Status=1 and t.ProjectID={projectid} {conditon}");
                    return res;
                }
            }
        }

        private string GetCondition(List<int> sectionId, int productId, int materialId, int routeId, int checkType, string sn, string result, List<long> ids,
            string starttime, string endtime, int userId, int userCheck)
        {
            var conditon = string.Empty;

            if (sectionId.Any())
            {
                conditon += $" and t.SectionID in ({string.Join(",", sectionId)})";
            }
            if (userCheck > 0)
            {
                conditon += $" and t.UserID>0";
            }

            if (productId > 0)
            {
                conditon += $" and t.ProductID={productId}";
            }
            if (materialId > 0)
            {
                conditon += $" and t.MaterialID={materialId}";
            }
            if (routeId > 0)
            {
                conditon += $" and t.RouteID={routeId}";
            }
            if (checkType > 0)
            {
                conditon += $" and t.CheckType={checkType}";
            }
            if (!string.IsNullOrEmpty(sn))
            {
                conditon += $" and t.SN={sn}";
            }
            if (!string.IsNullOrEmpty(result))
            {
                conditon += $" and t.Result='{result}'";
            }
            if (ids.Any())
            {
                conditon += $" and t.ID in ({string.Join(",", ids)})";
            }
            if (!string.IsNullOrEmpty(starttime) && !string.IsNullOrEmpty(endtime))
            {
                conditon += $" and t.CreateTime<='{endtime}' and t.CreateTime >= '{starttime}'";
            }
            if(userId > 0)
            {
                conditon += $" and t.UserID={userId}";
            }

            return conditon;
        }

        public SnTrace GetSnTrace(long id, int projectid)
        {
            using (var conn = GetDbConnection())
            {
                var sql = $"select * from {TabelNameConstant.SnTraceTable} where ID={id} and Status=1 and ProjectID={projectid}";
                var data = conn.QuerySingleOrDefault<SnTrace>(sql);
                return data;
            }
        }
        /// <summary>
        /// 通过TraceID获取详情数据
        /// </summary>
        /// <returns></returns>
        public IEnumerable<SnTraceDetail> GetSingleTraceDetailList(long traceId, int projectid)
        {
            var snTraces = new List<SnTraceDetail>();
            var subTables = GetSubTableList(TabelNameConstant.SnTraceDetailTable);
            if (subTables.Count > 0)
            {
                Parallel.ForEach(subTables, new ParallelOptions { MaxDegreeOfParallelism = subTables.Count },
                    t => { snTraces.AddRange(GetSingleTraceDetails(t, traceId, projectid)); });
            }            
            Task.WaitAll();
            return snTraces.ToList();
        }

        private IEnumerable<SnTraceDetail> GetSingleTraceDetails(SubTable table, long traceId, int projectid)
        {
            var conditon = string.Empty;
            if (traceId > 0)
            {
                conditon += $" and TraceID={traceId}";
            }

            var sql = $@"select ID,ItemID,TraceID,Result,Value,ItemName
from {table.name}
where Status=1 and ProjectID={projectid} {conditon}
order by CreateTime";
            var dataList = GetDataList<SnTraceDetail>(sql);
            return dataList;
        }

        public bool InsertTraceDetail(SnTrace trace, List<SnTraceDetailList> details, int projectid)
        {
            var tables = GetSubTableList(TabelNameConstant.SnTraceDetailTable);
            if (!tables.Any())
            {
                return false;
            }
            using (var conn = GetDbConnection())
            {
                var now = DateTime.Now;
                var tran = BeginTransaction(conn);
                try
                {
                    var time = DateTime.Now.ToString(ParameterConstant.DateTimeFormat);
                    var sql = $"insert into {TabelNameConstant.SnTraceTable} (SN,ProductID,MaterialID,SectionID,MachineID,WorkOrder,RouteID," +
                        $"UserID,Result,CreateTime,ProjectID,Status,CheckType) values('{trace.SN}',{trace.ProductID},{trace.MaterialID},{trace.SectionID},{trace.MachineID}," +
                        $"'{trace.WorkOrder}',{trace.RouteID},{trace.UserID},'{trace.Result}','{time}',{projectid},1,{trace.CheckType});";
                    sql += "SELECT @@identity;";//@ID=SCOPE_IDENTITY();
                    var traceId = conn.Query<long>(sql, tran).FirstOrDefault();
                    foreach (var detail in details)
                    {
                        var table = tables.FirstOrDefault(t => t.validtime.Year == now.Year && t.validtime.Month == now.Month);
                        if (table != null)
                        {
                            if (detail.Value.HasValue)
                            {
                                var dSQL = $"insert into {table.name}" +
    $"(TraceID,MachineID,SN,ItemID,ItemName,Value,Result,CreateTime,ProjectID,Status) values" +
    $"({traceId},{trace.MachineID},'{trace.SN}',{detail.ItemID},'{detail.ItemName}',{detail.Value.Value}," +
    $"'{detail.Result}','{time}',{projectid},1)";
                                conn.Execute(dSQL, tran);
                            }
                            else
                            {
                                var dSQL = $"insert into {table.name}" +
    $"(TraceID,MachineID,SN,ItemID,ItemName,Result,CreateTime,ProjectID,Status) values" +
    $"({traceId},{trace.MachineID},'{trace.SN}',{detail.ItemID},'{detail.ItemName}'," +
    $"'{detail.Result}','{time}',{projectid},1)";
                                conn.Execute(dSQL, tran);
                            }
                        }
                    }
                    Commit(tran, conn);
                    return true;
                }
                catch(Exception ex)
                {
                    Logger.WriteLineError(ex.ToString());
                    Rollback(tran, conn);
                    return false;
                }
            }
        }

        /// <summary>
        /// 删除所有数据
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public bool DeleteData(long id)
        {
            var tables = GetSubTableList(TabelNameConstant.SnTraceDetailTable);
            using (var conn = GetDbConnection())
            {
                var tran = BeginTransaction(conn);
                try
                {
                    var sql = $"update {TabelNameConstant.SnTraceTable} set Status={(int)RowState.Invalid} where ID={id}";
                    conn.Execute(sql);
                    foreach(var table in tables)
                    {
                        var sql2 = $"update {table.name} set Status={(int)RowState.Invalid} where TraceID={id}";
                        conn.Execute(sql2);
                    }
                    Commit(tran, conn);
                    return true;
                }
                catch
                {
                    Rollback(tran, conn);
                    return false;
                }
            }
        }

        /// <summary>
        /// 只删除详情表数据
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public bool DeleteDetail(long id)
        {
            var tables = GetSubTableList(TabelNameConstant.SnTraceDetailTable);
            using (var conn = GetDbConnection())
            {
                var tran = BeginTransaction(conn);
                try
                {
                    foreach (var table in tables)
                    {
                        var sql = $"update {table.name} set Status={(int)RowState.Invalid} where TraceID={id}";
                        conn.Execute(sql);
                    }
                    Commit(tran, conn);
                    return true;
                }
                catch
                {
                    Rollback(tran, conn);
                    return false;
                }
            }
        }

        /// <summary>
        /// 插入检验数据，并返回有插入ID和顺序序号的检验详情数据
        /// </summary>
        /// <returns></returns>
        public long InsertTraceDetailReturnTraceIdNumberIndex(SnTrace trace, List<SnTraceDetailList> details, int projectid, 
                out List<SnTraceDetailList> resDetails)
        {
            resDetails = new List<SnTraceDetailList>();
            var tables = GetSubTableList(TabelNameConstant.SnTraceDetailTable);
            if (!tables.Any())
            {
                return 0;
            }
            using (var conn = GetDbConnection())
            {
                var now = DateTime.Now;
                var tran = BeginTransaction(conn);
                try
                {
                    var time = trace.CreateTime.ToString(ParameterConstant.DateTimeFormat);
                    var sql = $"insert into {TabelNameConstant.SnTraceTable} (SN,ProductID,MaterialID,SectionID,MachineID,WorkOrder,RouteID," +
                        $"UserID,Result,CreateTime,ProjectID,Status,CheckType) values('{trace.SN}',{trace.ProductID},{trace.MaterialID},{trace.SectionID},{trace.MachineID}," +
                        $"'{trace.WorkOrder}',{trace.RouteID},{trace.UserID},'{trace.Result}','{time}',{projectid},1,{trace.CheckType});";
                    sql += "SELECT @@identity;";//@ID=SCOPE_IDENTITY();
                    var traceId = conn.Query<long>(sql, tran).FirstOrDefault();
                    foreach (var detail in details)
                    {
                        var table = tables.FirstOrDefault(t => t.validtime.Year == now.Year && t.validtime.Month == now.Month);
                        if (table != null)
                        {
                            if (detail.Value.HasValue)
                            {
                                var dSQL = $"insert into {table.name}" +
    $"(TraceID,MachineID,SN,ItemID,ItemName,Value,Result,CreateTime,ProjectID,Status) values" +
    $"({traceId},{trace.MachineID},'{trace.SN}',{detail.ItemID},'{detail.ItemName}',{detail.Value.Value}," +
    $"'{detail.Result}','{time}',{projectid},1);";
                                dSQL += "SELECT @@identity;";
                                detail.ID = conn.Query<long>(dSQL, tran).FirstOrDefault();
                                resDetails.Add(detail);
                            }
                            else
                            {
                                var dSQL = $"insert into {table.name}" +
    $"(TraceID,MachineID,SN,ItemID,ItemName,Result,CreateTime,ProjectID,Status) values" +
    $"({traceId},{trace.MachineID},'{trace.SN}',{detail.ItemID},'{detail.ItemName}'," +
    $"'{detail.Result}','{time}',{projectid},1);";
                                dSQL += "SELECT @@identity;";
                                detail.ID = conn.Query<long>(dSQL, tran).FirstOrDefault();
                                resDetails.Add(detail);
                            }
                        }
                    }
                    Commit(tran, conn);
                    return traceId;
                }
                catch (Exception ex)
                {
                    Logger.WriteLineError("Insert Trace Detail Data Error:" + ex.ToString());
                    Rollback(tran, conn);
                    return 0;
                }
            }
        }

        /// <summary>
        /// 插入检验数据，并返回有插入ID和顺序序号的检验详情数据
        /// </summary>
        /// <returns></returns>
        public bool InsertTraceOnlyDetailsReturnNumerIndex(SnTrace trace, List<SnTraceDetailList> details, int projectid,
                string result, out List<SnTraceDetailList> resDetails)
        {
            resDetails = new List<SnTraceDetailList>();
            var tables = GetSubTableList(TabelNameConstant.SnTraceDetailTable);
            if (!tables.Any())
            {
                return false;
            }
            using (var conn = GetDbConnection())
            {
                var now = DateTime.Now;
                var tran = BeginTransaction(conn);
                try
                {
                    if (trace.Result != result)
                    {
                        var uSQL = $"update {TabelNameConstant.SnTraceTable} set Result='{result}' where ID={trace.ID} and Status=1 and ProjectID={projectid}";
                        conn.Execute(uSQL, tran);
                    }
                    var time = trace.CreateTime.ToString(ParameterConstant.DateTimeFormat);
                    foreach (var detail in details)
                    {
                        var table = tables.FirstOrDefault(t => t.validtime.Year == now.Year && t.validtime.Month == now.Month);
                        if (table != null)
                        {
                            if (detail.Value.HasValue)
                            {
                                var dSQL = $"insert into {table.name}" +
    $"(TraceID,MachineID,SN,ItemID,ItemName,Value,Result,CreateTime,ProjectID,Status) values" +
    $"({trace.ID},{trace.MachineID},'{trace.SN}',{detail.ItemID},'{detail.ItemName}',{detail.Value.Value}," +
    $"'{detail.Result}','{time}',{projectid},1);";
                                dSQL += "SELECT @@identity;";
                                detail.ID = conn.Query<long>(dSQL, tran).FirstOrDefault();
                                resDetails.Add(detail);
                            }
                            else
                            {
                                var dSQL = $"insert into {table.name}" +
    $"(TraceID,MachineID,SN,ItemID,ItemName,Result,CreateTime,ProjectID,Status) values" +
    $"({trace.ID},{trace.MachineID},'{trace.SN}',{detail.ItemID},'{detail.ItemName}'," +
    $"'{detail.Result}','{time}',{projectid},1);";
                                dSQL += "SELECT @@identity;";
                                detail.ID = conn.Query<long>(dSQL, tran).FirstOrDefault();
                                resDetails.Add(detail);
                            }
                        }
                    }                    
                    Commit(tran, conn);
                    return true;
                }
                catch (Exception ex)
                {
                    Logger.WriteLineError("Insert Trace Detail Data Error:" + ex.ToString());
                    Rollback(tran, conn);
                    return false;
                }
            }
        }

        /// <summary>
        /// 通过多个项目ID 获取TraceID
        /// </summary>
        /// <returns></returns>
        public IEnumerable<long> GetTraceIdList(List<long> ids, long traceId, List<int> itemIds,
            string itemName, string starttime, string endtime, int projectid)
        {
            var snTraceIds = new List<long>();
            var subTables = GetSubTableList(TabelNameConstant.SnTraceDetailTable);
            if (subTables.Any())
            {
                Parallel.ForEach(subTables, new ParallelOptions { MaxDegreeOfParallelism = subTables.Count },
                    t => { snTraceIds.AddRange(GetSnTraceIds(t, ids, traceId, itemIds, itemName, starttime, endtime, projectid)); });
                Task.WaitAll();
            }
            return snTraceIds.ToList();
        }

        private IEnumerable<long> GetSnTraceIds(SubTable table, List<long> ids, long traceId, List<int> itemIds, string itemName
            , string starttime, string endtime, int projectid)
        {
            var conditon = string.Empty;
            var stime = starttime.ToDateTime();
            var etime = endtime.ToDateTime();
            if (ids.Any())
            {
                var detailIds = new List<int>();
                if (DateTime.Now.Year == table.validtime.Year && DateTime.Now.Month == table.validtime.Month)
                {
                    ids.Where(t => t >= table.startid);
                }
                else
                {
                    ids.Where(t => t <= table.endid && t >= table.startid).ToList();
                }

                if (detailIds.Any())
                {
                    conditon = $" and ID in ({string.Join(",", detailIds)}) ";
                }
                else
                {
                    return new List<long>();
                }
            }

            if (traceId > 0)
            {
                conditon += $" and TraceID={traceId}";
            }

            if (!string.IsNullOrEmpty(itemName))
            {
                conditon += $" and ItemName='{itemName}'";
            }

            if (itemIds.Any())
            {
                conditon += $" and ItemID in ({string.Join(",", itemIds)})";
            }

            var sql = $@"select TraceID
    from {table.name}
    where Status=1 and ProjectID={projectid} and CreateTime<='{endtime}' and 
    CreateTime>='{starttime}' {conditon} 
    group by TraceID ";
            var dataList = GetDataList<long>(sql);

            return dataList;
        }

        public override void Dispose()
        {
            throw new NotImplementedException();
        }
    }
}
