﻿using System;
using System.Collections.Generic;
using System.Text;
using Dapper;
using Siger.Middlelayer.Dapper.CheckTrace.Data;
using Siger.Middlelayer.Dapper.CheckTrace.Constant;
using System.Linq;
using System.Threading.Tasks;
using Siger.Middlelayer.Common.Extensions;
using Siger.Middlelayer.Common.Log;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.ModuleEnum;

namespace Siger.Middlelayer.Dapper.CheckTrace.Repostriories
{
    public class TraceDetailTableRepository : TraceDetailRepository
    {
        public TraceDetailTableRepository(int companyId, int projectId) : base(companyId, projectId)
        {
        }
        /// <summary>
        /// 查询表是否存在
        /// </summary>
        /// <returns></returns>
        public bool TableIsExsit(string tablename, string schemaname)
        {
            using (var conn = GetDbConnection())
            {
                var sql = $"select TABLE_NAME from information_schema.TABLES where TABLE_NAME = '{tablename}' and TABLE_SCHEMA='{schemaname}';";
                var data = conn.Query<string>(sql);
                return !string.IsNullOrEmpty(data.FirstOrDefault());
            }
        }

        public void CreateTable(string tablename, string true_tablename, long startid)
        {
            using (var conn = GetDbConnection())
            {
                var sql = string.Empty;
                switch (tablename)
                {
                    case TabelNameConstant.SnTraceTable:
                        {
                            sql = "CREATE TABLE `" + true_tablename + @"`  (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `SN` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '二维码',
  `ProductID` int(11) NOT NULL COMMENT '产品ID',
  `MaterialID` int(11) NOT NULL DEFAULT 0 COMMENT '物料ID',
  `SectionID` int(20) NOT NULL COMMENT '工位ID',
  `MachineID` int(11) NOT NULL COMMENT '设备ID',
  `WorkOrder` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '工单号',
  `RouteID` int(11) NOT NULL DEFAULT 0 COMMENT '产品工序ID',
  `UserID` int(20) NOT NULL DEFAULT 0 COMMENT '用户MID',
  `Result` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '结果',
  `CheckType` int(2) NOT NULL DEFAULT 0 COMMENT '检验类型',
  `CreateTime` datetime(0) NOT NULL,
  `ProjectID` int(20) NOT NULL DEFAULT 0,
  `Status` int(2) NOT NULL DEFAULT 1,
  PRIMARY KEY(`ID`) USING BTREE,
 INDEX `sn`(`SN`) USING BTREE,
 INDEX `UserID`(`UserID`) USING BTREE,
 INDEX `CreateTime`(`CreateTime`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = DYNAMIC; ";
                            break;
                        }
                    case TabelNameConstant.SnTraceDetailTable:
                        {
                            sql = @"CREATE TABLE `" + true_tablename + @"`  (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `MachineID` int(11) NOT NULL DEFAULT 0,
  `TraceID` bigint(20) NOT NULL DEFAULT 0 COMMENT 'siger_tr_sn_trace.id(trace表ID)',
  `SN` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '二维码',
  `ItemID` int(11) NOT NULL DEFAULT 0 COMMENT 'siger_qms_inspection_standard.id(项目ID)',
  `ItemName` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '项目名称',
  `Value` double NULL DEFAULT NULL COMMENT '检测值',
  `Result` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '结果',
  `CreateTime` datetime(0) NOT NULL,
  `ProjectID` int(20) NOT NULL DEFAULT 0,
  `Status` int(20) NOT NULL DEFAULT 1,
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `index_createtime`(`CreateTime`) USING BTREE,
  INDEX `index_itemname`(`ItemName`) USING BTREE,
  INDEX `index_itemid`(`ItemID`) USING BTREE,
  INDEX `index_traceid`(`TraceID`, `ProjectID`, `Status`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = " + startid + " CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = DYNAMIC;";
                            break;
                        }
                    case TabelNameConstant.SubTableTable:
                        {
                            sql = "CREATE TABLE `" + true_tablename + @"`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '分表表名',
  `tablename` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '原始表名',
  `startid` bigint(20) NOT NULL DEFAULT 0 COMMENT '分表最小ID',
  `endid` bigint(20) NOT NULL DEFAULT 0 COMMENT '分表最大ID,新建表默认0',
  `validtime` datetime(0) NOT NULL COMMENT '有效月份',
  `createtime` datetime(0) NOT NULL COMMENT '创建时间',
  `status` int(2) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = DYNAMIC;";
                            break;
                        }
                }
                var data = conn.Execute(sql);
            }
        }

        public long GetTableMaxID(string tablename)
        {
            using (var conn = GetDbConnection())
            {
                var sql = $"select max(ID) from {tablename}";
                var data = conn.Query<string>(sql);
                bool num = long.TryParse(data.First(), out long result);
                return num ? result : 0L;
            }
        }

        public long GetTableMinID(string tablename)
        {
            using (var conn = GetDbConnection())
            {
                var sql = $"select min(ID) from {tablename}";
                var data = conn.Query<string>(sql);
                bool num = long.TryParse(data.First(), out long result);
                return num ? result : 1L;
            }
        }

        public SubTable GetSubTableInfo(string name, string tablename)
        {
            using (var conn = GetDbConnection())
            {
                var sql = $"select * from {TabelNameConstant.SubTableTable} where name='{name}' and tablename='{tablename}' and status=1";
                var dataList = conn.Query<SubTable>(sql);
                return dataList.FirstOrDefault();
            }
        }

        public bool InsertSubTable(SubTable entity)
        {
            using (var conn = GetDbConnection())
            {
                var sql = $"INSERT INTO `siger_project_subtable` (name,tablename,startid,endid,validtime,createtime,status) VALUES ('{entity.name}', '{entity.tablename}', {entity.startid}, {entity.endid}, '{entity.validtime.ToString(ParameterConstant.DateTimeFormat)}', '{entity.createtime.ToString(ParameterConstant.DateTimeFormat)}', {entity.status});";
                var data = conn.Execute(sql);
                return data > 0;
            }
        }

        public bool UpdateSubTableEndId(int id, long endid)
        {
            using (var conn = GetDbConnection())
            {
                var sql = $"update siger_project_subtable set endid={endid} where id={id}";
                var data = conn.Execute(sql);
                return data > 0;
            }
        }

        public override void Dispose()
        {
            throw new NotImplementedException();
        }
    }
}
