﻿using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Redis.RedisEntities;

namespace Siger.Middlelayer.Redis.Repositories
{
    public class MachineMouldUsageRepository : RedisRepositoryBase
    {
        public MachineMouldUsageRepository(int companyId, int projectId) : base(companyId, projectId)
        {
        }

        /// <summary>
        /// 获取模具压模次数
        /// </summary>
        /// <returns></returns>
        public int GetMachineMouldUsage(int machineId, string mouldName)
        {
            try
            {
                var data = Client.HGet(HashMachineMouldUsage, $"{machineId}_{mouldName}");
                if (!string.IsNullOrEmpty(data))
                {
                    var usage = JsonHelper.DeserializerJsonResult<MachineMouldUsage>(data);
                    return usage.usage;
                }

                return 0;
            }
            catch
            {
                return 0;
            }
            finally
            {
                Dispose();
            }
        }

        public void Dispose()
        {
            Client?.Dispose();
        }
    }
}
