﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.Middlelayer.Redis.Repositories
{
    public class MouldConfigRepository : RedisRepositoryBase
    {
        public MouldConfigRepository(int companyId, int projectId) : base(companyId, projectId)
        {

        }

        /// <summary>
        /// 获取当前设备配置的模具
        /// </summary>
        /// <param name="machindId"></param>
        /// <returns></returns>
        public string GetMachineMould(int machindId)
        {
            try
            {
                var data = Client.HGet(HashMouldConfig, machindId.ToString());
                if (!string.IsNullOrEmpty(data))
                {
                    return data;
                }
            }
            finally
            {
                Dispose();
            }

            return string.Empty;
        }

        /// <summary>
        /// 手机端上下模
        /// </summary>
        /// <param name="machineId"></param>
        /// <param name="mouldName"></param>
        public void UploadMould(int machineId, string mouldName)
        {
            try
            {
                Client.HSet(HashMouldConfig, machineId.ToString(), mouldName);
            }
            finally
            {
                Dispose();
            }
        }

        public void DownMould(int machineId, string mouldName)
        {
            try
            {
                var lst = Client.HGetAll(HashMouldConfig);
                foreach(var m in lst)
                {
                    if (m.Value==mouldName)
                    {
                        Client.HSet(HashMouldConfig, m.Key, "");
                    }
                }
                
            }
            finally
            {
                Dispose();
            }
        }

        public void Dispose()
        {
            Client?.Dispose();
        }
    }
}
