﻿using System;
using System.Text;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Redis.RedisEntities;

namespace Siger.Middlelayer.Redis.Repositories
{
    public class QMSRatedTimeLifeConfigRepository : RedisRepositoryBase
    {
        private readonly bool _dispose;
        public QMSRatedTimeLifeConfigRepository(int companyId, int projectId, bool dispose = true) : base(companyId, projectId)
        {
            _dispose = dispose;
        }

        public void AddRateLifeConfig(int machineId, double qualifiedTime, double tiliaocaoTime, int changesCycle,int defaultType,int speedTime,int line)
        {
            var redisEntity = new QMSRatedTimeLifeConfig
            {
                machine_id = machineId,
                qualifiedTime = qualifiedTime,
                tiliaocaoTime = tiliaocaoTime,
                changesCycle = changesCycle,
                defaultType= defaultType,
                speedTime= speedTime,
                sectionId= line
            };
            try
            {
                Client.HSet(HashQMSRatedTimeLifeConfig, machineId.ToString(), JsonHelper.SerializerToJsonString(redisEntity));
            }
            catch
            {
                throw;
            }
            finally
            {
                if (_dispose)
                {
                    Dispose();
                }
            }
        }

        public void RemoveRateLifeConfig(int machineId)
        {
            try
            {
                Client.HDel(HashQMSRatedTimeLifeConfig, machineId.ToString());
            }
            catch
            {
                throw;
            }
            finally
            {
                if (_dispose)
                {
                    Dispose();
                }
            }
        }

        public void Dispose()
        {
            Client?.Dispose();
        }
    }
}
