﻿using Newtonsoft.Json;
using Siger.Middlelayer.Redis.RedisEntities;
using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.Middlelayer.Redis.Repositories
{
    public class ToolSendMessageTypeRepository : RedisRepositoryBase
    {
        private readonly bool _dispose;
        public ToolSendMessageTypeRepository(int companyId, int projectId, bool dispose = true) : base(companyId, projectId)
        {
            _dispose = dispose;
        }
        public void Dispose()
        {
            Client?.Dispose();
        }
        public void Update(ToolSendMessageKey key, string record)
        {
            if (string.IsNullOrEmpty(record))
                return;
            try
            {
                Client.HSet(ToolSendMessageType, key.GetKey(), record);
            }
            catch
            {
                throw;
            }
            finally
            {
                if (_dispose)
                {
                    Dispose();
                }
            }
        }
        public void Delete(ToolSendMessageKey key)
        {
            try
            {
                Client.HDel(ToolSendMessageType, key.GetKey());
            }
            catch
            {
                throw;
            }
            finally
            {
                Client?.Dispose();
            }
        }
    }
    public class ToolSendMessageKey
    {
        public int cid { get; set; }
        public int pid { get; set; }
        public int mid { get; set; }
        public int spindle { get; set; }
        public string tn { get; set; }
        public string pn { get; set; }
        public string GetKey()
        {
            return $"{cid}_{pid}_{mid}_{spindle}_{tn}_{pn}";
        }
    }
}
