/**
 * aui-sharebox.js
 * @author 
 * Licensed under the MIT license.
 * http://www.opensource.org/licenses/mit-license.php
 */
(function( window, undefined ) {
    "use strict";
    var auiSelectbox = function() {
    };
    var isShow = false;
    auiSelectbox.prototype = {
        init: function(params,callback){
            this.frameBounces = params.frameBounces;
            this.col = params.col;
            this.content = params.content;
            this.cancelTitle = params.cancelTitle;
            this.maskDiv;
            this.shareBoxDiv;
            var self = this;
            self.open(params,callback);

        },
        open: function(params,callback) {
            var shareboxHtml='',listsHtml = '';
            var self = this;
            if(self.shareBoxDiv || !self.content)return;
            if(!self.maskDiv){
                self.maskDiv = document.createElement("div");
                self.maskDiv.className = "aui-mask";
                document.body.appendChild(self.maskDiv);
            }
            if(!self.col)self.col = 5;
            self.shareBoxDiv = document.createElement("div");
            self.shareBoxDiv.className = "selectbox";
            document.body.appendChild(self.shareBoxDiv);
            
            listsHtml+=this.content;

            if(self.cancelTitle){
                listsHtml += '<div class="aui-sharebox-close-btn aui-border-t">'+this.cancelTitle+'</div>';
            }
            // var screenHeight = api.screenHeight; 
            // console.log(screenHeight);
            self.shareBoxDiv.innerHTML = listsHtml;
            var actionsheetHeight = self.shareBoxDiv.offsetHeight;
            self.maskDiv.classList.add("aui-mask-in");
            // self.shareBoxDiv.style.webkitTransform = self.shareBoxDiv.style.transform = "translate3d(0,0,0)";
            self.shareBoxDiv.style.opacity = 1;


            self.shareBoxDiv.addEventListener("touchmove", function(event){
                event.preventDefault();
            })
            self.maskDiv.addEventListener("touchmove", function(event){
                event.preventDefault();
            })
            if(typeof(api) != 'undefined' && typeof(api) == 'object' && self.frameBounces){
                api.setFrameAttr({
                    bounces:false
                });
            }


            var shareboxButtons = document.querySelectorAll(".equipselitem");
            if(shareboxButtons && shareboxButtons.length > 0){
                setTimeout(function(){
                    self.maskDiv.onclick = function(){self.close();return;};
                    for(var ii = 0; ii < shareboxButtons.length; ii++){
                        (function(e){
                            shareboxButtons[e].onclick = function(){
                                if(self.lists[e].value){
                                    var _value = self.lists[e].value;
                                }else{
                                    var _value = null;
                                }
                                if(callback){
                                    callback({
                                        buttonIndex: e+1,
                                        buttonValue:_value
                                    });
                                };
                                self.close();
                                return;
                            }
                        })(ii)
                    }
                }, 350)

            }
            document.querySelector(".aui-sharebox-close-btn").onclick = function(){self.close();return;};
        },
        close: function(){
            var self = this;
            if(typeof(api) != 'undefined' && typeof(api) == 'object' && self.frameBounces){
                api.setFrameAttr({
                    bounces:true
                });
            }
            if(self.shareBoxDiv){
                var actionsheetHeight = self.shareBoxDiv.offsetHeight;
                // self.shareBoxDiv.style.webkitTransform = self.shareBoxDiv.style.transform = "translate3d(0,"+actionsheetHeight+"px,0)";
                self.maskDiv.style.opacity = 0;
                setTimeout(function(){
                    if(self.maskDiv){
                        self.maskDiv.parentNode.removeChild(self.maskDiv);
                    }
                    self.shareBoxDiv.parentNode.removeChild(self.shareBoxDiv);
                    self.maskDiv = self.shareBoxDiv = false;
                }, 300)
            }
        }
    };
    window.auiSelectbox = auiSelectbox;
})(window);